#!/usr/bin/env python 
'''
Copyright (C) 2009 Daniel S. Trommel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'''
import random, math, inkex, cubicsuperpath

def applyMappingToPoint(pt, rx, ry, radius, factor):
	#----    
	#--    
	dx = pt[0] - rx
	dy = pt[1] - ry
	dist = math.hypot(dx,dy)
	#info = "dx=" + str(dx) + ", dy=" + str(dy) +  ", dist=" + str(dist) + "\n"
	#inkex.errormsg(info)
	#----    
	#--    
	if dist < radius:
		newdist = radius - dist
	else:
		info = "Invalid point (outside outer cicle!): " + str(dist) + " >= " + str(radius) + "\n"
		inkex.errormsg(info)
		exit()           
	#----    
	#--    
	if dx == 0:
		nx = 0
		if dy < 0:
			ny = -newdist
		else:
			ny = newdist
	elif dy == 0:
		ny = 0
		if dx < 0:
			nx = -newdist
		else:
			nx = newdist
	else: 		
		alpha = math.atan2(dy,dx)
		nx = math.cos(alpha)*newdist
		ny = math.sin(alpha)*newdist
		if (dx < 0):
			x = -nx
		if (dy < 0):
			y = -ny
	#----    
	#--    
	pt[0]= factor * (rx + nx)
	pt[1]= factor * (ry + ny)

class PathInsideOut(inkex.Effect):
    def __init__(self):
        inkex.Effect.__init__(self)
        self.OptionParser.add_option("--title")
        self.OptionParser.add_option("-x", "--originx",
                        action="store", type="float", 
                        dest="originx", default=0.0,
                        help="origin from which will be folded inside-out, X")
        self.OptionParser.add_option("-y", "--originy",
                        action="store", type="float", 
                        dest="originy", default=0.0,
                        help="origin from which will be folded inside-out, Y")
        self.OptionParser.add_option("-a", "--radius",
                        action="store", type="float", 
                        dest="radius", default=100.0,
                        help="radius of circle, R")
        self.OptionParser.add_option("-f", "--factor",
                        action="store", type="float", 
                        dest="factor", default=500.0,
                        help="radius of outer circle, R")
						
    def effect(self):
		rx = self.options.originx
		ry = self.options.originy
		radius = self.options.radius
		factor = self.options.factor
		for id, node in self.selected.iteritems():
			if node.tag == inkex.addNS('path','svg'):
				d = node.get('d')
				p = cubicsuperpath.parsePath(d)
				for subpath in p:
					for csp in subpath:
						
						pt = [csp[0][0], csp[0][1]]
						applyMappingToPoint(pt, rx, ry, radius, factor)
						csp[0][0] = pt[0] 
						csp[0][1] = pt[1] 
						
						pt = [csp[1][0], csp[1][1]]		
						applyMappingToPoint(pt, rx, ry, radius, factor)
						csp[1][0] = pt[0] 
						csp[1][1] = pt[1] 
						
						pt = [csp[2][0], csp[2][1]]		
						applyMappingToPoint(pt, rx, ry, radius, factor)
						csp[2][0] = pt[0] 
						csp[2][1] = pt[1]
						
				node.set('d',cubicsuperpath.formatPath(p))

if __name__ == '__main__':
    e = PathInsideOut()
    e.affect()


# vim: expandtab shiftwidth=4 tabstop=8 softtabstop=4 encoding=utf-8 textwidth=99
