#! /usr/bin/env python
# -*- coding: utf-8 -*-

import inkex, simplestyle, random

bgcolor = None

__version__ = '0.1'

inkex.localize()

class SimpleTransparencyFlattener(inkex.Effect):
    def __init__(self):
        inkex.Effect.__init__(self)
      
    def effect(self):
      global bgcolor
      namedview = self.getNamedView()
      if namedview:
        pageopacity = namedview[0].get(inkex.addNS('pageopacity', 'inkscape'))
        if float(pageopacity) != 1:
          namedview[0].set(inkex.addNS('pageopacity', 'inkscape'), '1.0')
        bgcolor = simplestyle.parseColor(namedview[0].get('pagecolor'))
      else:
        bgcolor = simplestyle.parseColor('#ffffff')
          
      if len(self.selected)==0:
        self.getAttribs(self.document.getroot())
      else:
        for id,node in self.selected.iteritems():
          self.getAttribs(node)   
                                 
    def getNamedView(self):
      return self.document.xpath('//svg:svg/sodipodi:namedview', namespaces=inkex.NSS)

    def getAttribs(self,node):
      self.changeStyle(node, -1)
      for child in node:
        self.getAttribs(child)  

    def changeStyle(self,node,object_opacity): 
      if node.attrib.has_key('style'):  
        style = node.get('style')
        if style:               
            stylemap = dict()
            declarations = style.split(';')
            for i,decl in enumerate(declarations):
                parts = decl.split(':', 2)
                if len(parts) == 2:
                    (prop, val) = parts
                    stylemap.update({prop.strip().lower() : val.strip()})
            if object_opacity != -1:
              stylemap = self.process_stop(stylemap, object_opacity)
            else:
             stylemap = self.process_props(stylemap)  
            newarray = []
            for key, value in stylemap.items():
              newarray.append(key + ':' + value)
            node.set('style', ';'.join(newarray))
                                                           
    def process_props(self,stylemap):      
      object_opacity = float(stylemap.get('opacity', '1.0'))   
      stylemap.update({'opacity' : '1.0'})
      
      fill_alpha = float(stylemap.get('fill-opacity', '1.0')) 
      stylemap.update({'fill-opacity' : '1.0'})
      
      stroke_alpha = float(stylemap.get('stroke-opacity', '1.0'))  
      stylemap.update({'stroke-opacity' : '1.0'})
      
      fill_c = stylemap.get('fill', '#ffffff');
      stroke_c = stylemap.get('stroke', '#ffffff');
      
      if simplestyle.isColor(fill_c):
        fill = simplestyle.parseColor(fill_c)        
        if object_opacity != 1 or fill_alpha != 1:
          new_fill = self.calc_color(fill[0], fill[1], fill[2], fill_alpha, object_opacity)
          stylemap.update({'fill' : '#' + new_fill}) 
      if fill_c.startswith('url(#'):
        id = fill_c[len('url(#'):fill_c.find(')')] 
        path = '//*[@id="%s"]' % id             
        self.process_gradient(path, object_opacity)
      
      if simplestyle.isColor(stroke_c):
        stroke = simplestyle.parseColor(stroke_c)  
        if object_opacity != 1 or stroke_alpha != 1:
          new_stroke = self.calc_color(stroke[0], stroke[1], stroke[2], stroke_alpha, opacity)
          stylemap.update({'stroke' : '#' + new_stroke})  
      if stroke_c.startswith('url(#'):
        id = stroke_c[len('url(#'):stroke_c.find(')')] 
        path = '//*[@id="%s"]' % id             
        self.process_gradient(path, object_opacity)
          
      return stylemap
      
    def process_gradient(self, path, object_opacity):
        grads = self.document.xpath(path, namespaces=inkex.NSS)
        for grad in grads:
          if len(grad.getchildren())==0:
            newpath = '//*[@id="%s"]' % grad.get(inkex.addNS('href', 'xlink'))[1:]          
            self.process_gradient(newpath, object_opacity)
          else:
            for child in grad:
              if child.get('id').startswith('stop'):
                self.changeStyle(child, object_opacity)
    
    def process_stop(self, stylemap, object_opacity):
      stop_alpha = float(stylemap.get('stop-opacity', '1.0')) 
      stylemap.update({'stop-opacity' : '1.0'})
      
      stop_c = stylemap.get('stop-color', '#ffffff');
      
      if simplestyle.isColor(stop_c):
        stop = simplestyle.parseColor(stop_c)
        if object_opacity != 1 or stop_alpha != 1:
          new_stop = self.calc_color(stop[0], stop[1], stop[2], stop_alpha, object_opacity)
          stylemap.update({'stop-color' : '#' + new_stop}) 
      
      return stylemap
        
    def _hexstr(self,r,g,b):
        return '%02x%02x%02x' % (int(round(r)),int(round(g)),int(round(b)))
    
    def calc_color(self,_r,_g,_b,_a,_o):
      r_bg = bgcolor[0]
      g_bg = bgcolor[1]
      b_bg = bgcolor[2]
      r = r_bg + _o * _a * (_r - r_bg)
      g = g_bg + _o * _a * (_g - g_bg)
      b = b_bg + _o * _a * (_b - b_bg)
      return self._hexstr(r, g, b)
    
if __name__ == '__main__':
    effect = SimpleTransparencyFlattener()
    effect.affect()