#!/usr/bin/env python

# Exports the texts in the document in format understood by
# LaTeX overpic package.
#
# (c) Christoph Lechner, Dec-5, 2015
# http://www.cl-projects.de/

import inkex
import sys
import simpletransform

class TemplateEffect(inkex.Effect):
	def __init__(self):
		# Call base class construtor.
		inkex.Effect.__init__(self)
        
	def effect(self):

		# obtain dimensions of SVG document
		svg = self.document.getroot()
		page_w = svg.get('width')
		page_h = svg.get('height')
        
	        #Create the string variable which will hold the formatted data (note that '\n' defines a line break)
        	outputString = ""
			
	        #Iterate through all the selected objects in Inkscape
        	for id, node in self.selected.iteritems():
			outputString += "***id="+id+"\n";

	     		#Check if the node is a text 
       			if node.tag == inkex.addNS('text','svg'):
				# collect all texts
				# loop over all elements (there should be a tspan)
				txt=""
				for stuff in node:
					txt += stuff.text + " "
					#for attr in dir(stuff):
					#	outputString += "obj.%s = %s\n" % (attr, getattr(stuff, attr))  

				# write format needed by LaTeX overpic
				outputString += "\\put(%s,%s){%s}\n" % (node.get('x'),node.get('y'), txt)

		outputString += "width=%s, height=%s\n" % (page_w,page_h)

		sys.stderr.write(outputString)

# Create effect instance and apply it.
effect = TemplateEffect()
effect.affect()
