import csv


class OLData():
    """
    Providing data in a dict for openlabel
    """


    def __init__(self, filename=None, delimit=';'):
        if filename != None:
            self.open(filename, delimit)
            

    def __del__(self):
        self.close()
    

    def __iter__(self):
        return(iter(self.data))


    def open(self, filename='data.csv', delimit=None):
        self.file = open(filename, mode='r')
        if delimit == None:
            dialect = csv.Sniffer().sniff(self.file.read(), ',;|\t')
            self.file.seek(0)
            self.data = csv.DictReader(self.file, dialect=dialect)
        else:
            self.data = csv.DictReader(self.file, delimiter=delimit)


    def close(self):
        if not self.file.closed:
            self.file.close()


    def fieldnames(self):
        return(self.data.fieldnames)
        

def main():
    data = OLData('data.csv')
    print(data.fieldnames())
    for i, row in enumerate(data):
        row['_KEY'] = i + 1
        print(row)
    

if __name__ == '__main__':
    main()
