#!/usr/bin/env python 
'''
This extension add or remove filters to current layer

Copyright (C) 2012 Jabiertxo Arraiza, jabier.arraiza@marker.es

Version 0.1 - Eraser

TODO:
Comment Better!!!

CHANGE LOG 
0.1 Start  30/07/2012

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'''

import inkex, sys, simplestyle, re
from lxml import etree

class FilterLayer(inkex.Effect):

    def __init__(self):
        inkex.Effect.__init__(self)
        self.OptionParser.add_option('-t', '--type', action = 'store', 
            type = 'string', dest = 'type', default = 'Add', 
            help = 'Add or remove filters to current layer')
    
    def selectTop(self):
        selected = []
        selectedSorted = None
        if self.selected is not None:
            for id, node in self.selected.iteritems():
                selected.append(id)
            for node in self.document.getroot().iter():
                idNode = node.get("id")
                if idNode in selected:
                    selectedSorted = node
        return selectedSorted

    def effect(self):
        saveout = sys.stdout
        sys.stdout = sys.stderr
        svg = self.document.getroot()
        typeOperation = self.options.type
        xpathStr = '//sodipodi:namedview'
        namedview = svg.xpath(xpathStr, namespaces=inkex.NSS)
        idLayer = namedview[0].get('{http://www.inkscape.org/namespaces/inkscape}current-layer');
        xpathStr = '//svg:g[@id="'+idLayer+'"]'
        layer = svg.xpath(xpathStr, namespaces=inkex.NSS)
        if typeOperation == "Add":
            element = self.selectTop()
            if element is not None:
                if element.get('style'):
                    matchObj = re.search( r'filter:url\(#.*?[^\)]\)', element.get('style'), re.M|re.I)
                    if matchObj:
                        filter = matchObj.group()
                        element.set('style',element.get('style').replace(filter,"").replace(";;",";"))
                        if layer[0].get('style'):
                            matchObj = re.search( r'filter:url\(#.*?[^\)]\)', layer[0].get('style'), re.M|re.I)
                            if matchObj:
                                element.set('style',element.get('style').replace(matchObj.group(),"").replace(";;",";"))
                            style = layer[0].get('style')+ ";" + filter;
                            layer[0].set('style',style.replace(";;",";"))
                        else:
                            layer[0].set('style',filter)
            else:
                print "Nothing selected"
        else:
            if layer[0].get('style'):
                matchObj = re.search( r'filter:url\(#.*?[^\)]\)', layer[0].get('style'), re.M|re.I)
                if matchObj:
                    layer[0].set('style',layer[0].get('style').replace(matchObj.group(),"").replace(";;",";"))
        layer[0].set('transform',"rotate(360)")
        sys.stdout = saveout

effect = FilterLayer()
effect.affect()
