#!/usr/bin/env python 
'''
Copyright (C) 2005 Aaron Spike, aaron@ekips.org
Modified by DR construction.
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'''
import inkex, simplestyle, simplepath, math

class DimLine(inkex.Effect):

    def __init__(self):
        inkex.Effect.__init__(self)
        self.OptionParser.add_option("--scale",
                        action="store", type="string", 
                        dest="scale", default="pc",
                        help="i need it")
        self.OptionParser.add_option("-d", "--extrudeL",
                        action="store", type="string",
                        dest="extrudeL", default="50",
                        help="Size of the dots placed at path nodes")
        self.OptionParser.add_option("--type",
                        action="store", type="string", 
                        dest="type", default="ortho",
                        help="i need it")
        self.OptionParser.add_option( "--fontsize",
                        action="store", type="int",
                        dest="fontsize", default="9",
                        help="Size of node label numbers")
        self.OptionParser.add_option("--extrudeD",
                        action="store", type="string", 
                        dest="extrudeD", default="down",
                        help="i need it")
        self.OptionParser.add_option("--tab",
                        action="store", type="string", 
                        dest="tab", default="sampling",
                        help="The selected UI-tab when OK was pressed") 
        self.OptionParser.add_option("--lineWidth",
                        action="store", type="float", 
                        dest="lineWidth", default="0.5",
                        help="i need it")
        self.OptionParser.add_option("--tickWidth",
                        action="store", type="float", 
                        dest="tickWidth", default="1.5",
                        help="i need it")


    def effect(self):
        for id, node in self.selected.iteritems():
            if node.tag == inkex.addNS('path','svg'):
                self.group = inkex.etree.SubElement( node.getparent(), inkex.addNS('g','svg') )
                self.lineGroup = inkex.etree.SubElement( self.group, inkex.addNS('g','svg') )
                self.numGroup = inkex.etree.SubElement( self.group, inkex.addNS('g','svg') )

                try:
                    t = node.get('transform')
                    self.group.set('transform', t)
                except:
                    pass

                style = simplestyle.formatStyle({ 'stroke': '#000', 'stroke-width':self.options.lineWidth * self.unittouu('1px'),'fill': 'none' })
                style2 = simplestyle.formatStyle({ 'stroke': '#000', 'stroke-width':self.options.tickWidth * self.unittouu('1px'),'stroke-linecap':'round','fill': 'none' })
                style3 = simplestyle.formatStyle({ 'stroke': '#000', 'stroke-width':self.options.lineWidth * (self.unittouu('1px')*1.1),'fill': 'none' })
                Li = (self.options.lineWidth + self.options.tickWidth) + self.unittouu('7px')
                p = simplepath.parsePath(node.get('d'))
				
                for cmd,params in p:
                    if cmd == 'Z' or cmd == 'z':
                        out_msg = "\t Closed paths do not work in this extension.\n\t Try - A line  "
                        inkex.errormsg(out_msg)
                        return
	    #non-looped atts
                font = self.options.fontsize * self.unittouu('1pt')
                exl = int(self.options.extrudeL) * self.unittouu('1px')
                x1set= p[0][1][-2]
                y1set= p[0][1][-1]
                y2set = p[-1][1][-1]
                x2set = p[-1][1][-2]
                if self.options.extrudeD == "right" and y1set == y2set or self.options.extrudeD == "left" and y1set == y2set:
                    out_msg = "\t Horizontal paths do not work in \n\t Offset direction. - left or right.\n\t Try Offset direction - up or down."
                    inkex.errormsg(out_msg)
                    return
                if self.options.extrudeD == "down" and x1set == x2set or self.options.extrudeD == "up" and x1set == x2set:
                    out_msg = "\t Vertical paths do not work in \n\t Offset direction. - up or down.\n\t Try Offset direction - left or right."
                    inkex.errormsg(out_msg)
                    return
                if self.options.extrudeD == "angle":
                           
                    boo = (math.sqrt(((x2set - x1set) ** 2) + ((y2set - y1set) ** 2)))
                    xfact =((x2set - x1set) / boo)* self.unittouu('1px')
                    yfact =((y2set -y1set) / boo)* self.unittouu('1px')
					
					#text x,y, degree
                    if x2set - x1set == 0: 
                        deg = -90							
                    else : deg = math.degrees(math.atan((y2set-y1set)/(x2set-x1set)))
                    if x2set - x1set < 0: 
                        ab = -5 #+ font
                    if x1set - x2set < 0 :
                        ab = 5 #+ font
                    if x2set - x1set == 0: 
                        ab = -5 #+ font
                    if x1set - x2set == 0 and y1set > y2set: 
                        ab = 5 #+ font
                    #else: 
                        #ab = 5							
                    xtp = (x1set+((x2set - x1set)/2 ))+((exl+ab)*yfact)
                    ytp = (y1set+((y2set - y1set)/2 ))-((exl+ab)*xfact)

                    #extrude line	
                    lineA_att = {
                      'style': style,
                      'd' : 'M '+str(x1set +(3 * yfact ))+','+str(y1set - (3 * xfact ))+' L '+str(x1set+((Li+exl)*yfact))+','+str(y1set-((Li+exl)*xfact))
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA_att )
                    #extrude line 2	
                    lineA1_att = {
                      'style': style,
                      'd' : 'M '+str(x2set+(3 * yfact ))+','+str(y2set - (3 * xfact ))+' L '+str(x2set+((Li+exl)*yfact))+','+str(y2set-((Li+exl)*xfact))
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA1_att )
					#measurement line
                    lineA2_att = {
                      'style': style3,
                      'd' : 'M '+str((x1set-Li *xfact) + (exl*yfact))+','+str((y1set-Li*yfact) - (exl*xfact) )+' L '+str((x2set+Li*xfact) + (exl*yfact))+','+str((y2set+Li*yfact) - (exl*xfact) )
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA2_att )
			        #tick
                    lineA3_att = {
                      'style': style2,
                      'd' : 'M '+str(x1set + ((exl-(Li/1.8))*yfact)-(Li/1.8)*xfact)+','+str(y1set - ((exl-(Li/1.8))*xfact)-(Li/1.8)*yfact) +' L '+str(x1set + ((exl+(Li/1.8))*yfact)+(Li/1.8)*xfact)+','+str(y1set - ((exl+(Li/1.8))*xfact)+(Li/1.8)*yfact)
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA3_att )
					#tick 2
                    lineA4_att = {
                      'style': style2,
                      'd' : 'M '+str(x2set + ((exl-(Li/1.8))*yfact)-(Li/1.8)*xfact)+','+str(y2set - ((exl-(Li/1.8))*xfact)-(Li/1.8)*yfact) +' L '+str(x2set + ((exl+(Li/1.8))*yfact)+(Li/1.8)*xfact)+','+str(y2set - ((exl+(Li/1.8))*xfact)+(Li/1.8)*yfact)
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA4_att )
					#Text
                    scale = float(self.options.scale) * self.unittouu('1px')
                    if boo < 0: boo = boo/-1
                    feet = (boo / scale)+.0055 
                    inch = ((boo / scale)+.0055)%1 * 100
                    if boo == 0: leng = " "							
                    if boo != 0 and feet > 0: leng = str(int(feet)) + " , " + str(int(inch)) 
                    if boo != 0 and feet < 1: leng = str(int(inch))
                    t='rotate(%f,%f,%f) matrix(1,0,0,1,0,-%f)' % (deg,xtp,ytp,0)
                        
                    self.addText(
                      self.numGroup,
                      xtp,
                      ytp,
                      leng, transform = t )

                num = 0
                if self.options.extrudeD != "angle":
                    if x1set < x2set : Lix = Li
                    if x1set > x2set : Lix = -Li
                    if y1set < y2set : Liy = Li
                    if y1set > y2set : Liy = -Li					
					#measurement line
                    if self.options.extrudeD == "up":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x1set-Lix)+','+str((y1set - exl) )+' L '+str(x2set+Lix)+','+str((y1set - exl) )
                        }
                    if self.options.extrudeD == "down":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x1set-Lix)+','+str((y1set + exl) )+' L '+str(x2set+Lix)+','+str((y1set + exl) )
                        }
                    if self.options.extrudeD == "left":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x1set - exl)+','+str(y1set-Liy)+' L '+str(x1set - exl)+','+str(y2set+Liy)
                        }
                    if self.options.extrudeD == "right":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x1set + exl)+','+str(y1set-Liy)+' L '+str(x1set + exl)+','+str(y2set+Liy) 
                        }
						
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),line21_att )
        #looped atts	
                    for cmd,params in p:						
                        font = int(self.options.fontsize) * self.unittouu('1pt')					    
                        exl = int(self.options.extrudeL) * self.unittouu('1px')
                        #runing coordiances 
                        x1 = p[num-1][1][-2]
                        y1 = p[num-1][1][-1]
                        x2 = p[num][1][-2]
                        y2 = p[num][1][-1]


                        if self.options.extrudeD == "up" or self.options.extrudeD == "down":
                            if x1set < x2set:
                                if 0 > (x2 - x1): boo = 0
                                if 0 < (x2 - x1): boo = (x2 - x1) 
                            if x1set > x2set:
                                if 0 < (x2 - x1): boo = 0
                                if 0 > (x2 - x1): boo = (x2 - x1)  
                        if self.options.extrudeD == "left" or self.options.extrudeD == "right":
                            if y2set < y1set:
                                if 0 > (y1 - y2): boo = 0
                                if 0 < (y1 - y2): boo = y1 - y2
                            if y2set > y1set:
                                if 0 < (y1 - y2): boo = 0
                                if 0 > (y1 - y2): boo = y1 - y2
                        if self.options.type == "ortho":
                            y1flex = y1set
                            x1flex = x1set
                        if self.options.type == "step": 
                            y1flex = y1
                            x1flex = x1

                        if self.options.extrudeD == "up":
							#text x,y, degree
                            xtp = x1 + ( boo/2 )
                            ytp = y1set - exl - (5*self.unittouu('1px'))
                            deg = 0	
                             #extrude line				
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1)+','+str(y1flex - (3 * self.unittouu('1px')) )+' L '+str(x1)+','+str((y1set - exl) - (Li))
                            }							
          
							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str(x1 - (Li/1.8))+','+str((y1set - exl) + (Li/1.8))+' L '+str(x1 + (Li/1.8))+','+str((y1set - exl) - (Li/1.8))
                            }
                        if self.options.extrudeD == "down":
							#text x,y, degree
                            xtp = x1 + ( boo/2 )
                            ytp = y1set + exl - (5*self.unittouu('1px')) 
                            deg = 0	
                            #extrude line						
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1)+','+str(y1flex + (3 * self.unittouu('1px')))+' L '+str(x1)+','+str((y1set + exl) + (Li * self.unittouu('1px')))
                            }
			
							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str(x1 - (Li/1.8))+','+str((y1set + exl) + (Li/1.8))+' L '+str(x1 + (Li/1.8))+','+str((y1set + exl) - (Li/1.8))
                            }
                        if self.options.extrudeD == "left":
							#text x,y, degree
                            xtp = x1set - exl - (5*self.unittouu('1px'))
                            ytp = y1 - ( boo/2 )
                            deg = -90
                            #extrude line						
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1flex - (3 * self.unittouu('1px')))+','+str(y1)+' L '+str((x1set - exl)- Li)+','+str(y1)
                            }
			
							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str((x1set - exl) + (Li/1.8))+','+str(y1 + (Li/1.8))+' L '+str(x1set - exl - (Li/1.8))+','+str(y1 - (Li/1.8))
                            }
                        if self.options.extrudeD == "right":
							#text x,y, degree
                            xtp = x1set + exl - (5*self.unittouu('1px')) 
                            ytp = y1 - ( boo/2 )
                            deg = -90
                            #extrude line						
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1flex + (3 * self.unittouu('1px')))+','+str(y1)+' L '+str((x1set + exl)+ Li)+','+str(y1)
                            }
 
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str((x1set + exl) + (Li/1.8))+','+str(y1 + (Li/1.8))+' L '+str(x1set + exl - (Li/1.8))+','+str(y1 - (Li/1.8))
                            }


							 
                        inkex.etree.SubElement(
                          self.lineGroup,
                          inkex.addNS('path','svg'),
                          line_att )						
          
                        inkex.etree.SubElement(
                          self.lineGroup,
                          inkex.addNS('path','svg'),
                          line3_att )
					    #Text
                        scale = float(self.options.scale) * self.unittouu('1px')
                        if boo < 0: boo = boo/-1
                        feet = (boo / scale)+.0055 
                        inch = ((boo / scale)+.0055)%1 * 100
                        if boo == 0: leng = " "							
                        if boo != 0 and feet > 0: leng = str(int(feet)) + " , " + str(int(inch)) 
                        if boo != 0 and feet < 1: leng = str(int(inch))
                        t='rotate(%f,%f,%f) matrix(1,0,0,1,0,-%f)' % (deg,xtp,ytp,0)
                        
                        self.addText(
                          self.numGroup,
                          xtp,
                          ytp,
                          leng, transform = t )


                        num += 1
                node.getparent().remove (node)


    def addText(self,node,x,y,text, transform=None):
                new = inkex.etree.SubElement(node,inkex.addNS('text','svg'))
                s = {'text-align': 'center', 'vertical-align': 'top','text-anchor': 'middle',
				    'font-size': int(self.options.fontsize) * self.unittouu('1pt') , 'fill-opacity': '1.0', 'stroke': 'none',
                    'font-weight': 'normal', 'font-style': 'normal', 'fill': '#000'}
                new.set('style', simplestyle.formatStyle(s))
                if not transform==None:
                  new.set('transform', str(transform))
                new.set('x', str(x))
                new.set('y', str(y))
                new.text = str(text)

                
if __name__ == '__main__':
    e = DimLine()
    e.affect()


# vim: expandtab shiftwidth=4 tabstop=8 softtabstop=4 encoding=utf-8 textwidth=99
