#!/usr/bin/env python
# Inkscape Layer-Based Animation Extensions
# By LordAlexG (lordalexgsoft@gmail.com)
# Export Layers as Separate Files

bEnableDebug = False

# These lines are only needed if you don't put the script directly into
# the installation directory
import sys, os
# Unix
sys.path.append('/usr/share/inkscape/extensions')
# OS X
sys.path.append('/Applications/Inkscape.app/Contents/Resources/extensions')
# Windows
sys.path.append('C:\Program Files\Inkscape\share\extensions')

import inkex

try:
	from subprocess import Popen, PIPE
	bsubprocess = True
except:
	bsubprocess = False


class ExportLayers(inkex.Effect):
	def __init__(self):
		inkex.Effect.__init__(self)
		self.OptionParser.add_option("--basename",
						action="store", type="string",
						dest="basename", default='export',
						help="")
		self.OptionParser.add_option("--outdir",
						action="store", type="string",
						dest="outdir", default=os.path.abspath('.'),
						help="")
		self.OptionParser.add_option("--inchidden",
						action="store", type="inkbool",
						dest="inchidden", default=False,
						help="")
		self.OptionParser.add_option("--dpi",
						action="store", type="int",
						dest="dpi", default=90,
						help="")

	def effect(self):
		docname			= self.options.basename
		path			= self.options.outdir
		self.bIncHidden	= self.options.inchidden
		self.dpi		= self.options.dpi
		#self.svg_file	= self.args[-1]

		# Find layers.
		layers = self.document.xpath("./svg:g[@inkscape:groupmode='layer']", namespaces=inkex.NSS)

		if(bEnableDebug):  self.dbgout = open(os.path.join(path, "debug.txt"), 'w')

		# Export each layer
		for l in layers:
			self.export_layer(l, os.path.join(path, docname))

		if(bEnableDebug):  self.dbgout.close()

	def export_layer(self, node, path):
		name = node.get(inkex.addNS('label',u'inkscape'))
		sub = node.xpath("./svg:g[@inkscape:groupmode='layer']", namespaces=inkex.NSS)
		style = node.get('style')
		
		if(bEnableDebug):  self.dbgout.write(str(name)+" -> "+str(style)+"\n")
		
		# Skip hidden if option not set
		if (not style or style=="display:none"):
			if not self.bIncHidden:  return
			else:
				# Show layer
				node.set('style', 'display:inline')
				self.document.write(self.svg_file)
		
		# Search sub-layers or export current one
		if sub:
			for l in sub:
				self.export_layer(l, path+'_'+name)
		else:
			id = node.get('id')
			filename = path+("_%s.png" % name)
			command = "inkscape --export-area-page --export-id=%s --export-id-only --export-dpi=%d --export-png=\"%s\" \"%s\"" % (id, self.dpi, filename, self.svg_file)
			
			if(bEnableDebug):  self.dbgout.write(command+'\n')
			
			if bsubprocess:
				p = Popen(command, shell=True, stdout=PIPE, stderr=PIPE)
				return_code = p.wait()
				f = p.stdout
				err = p.stderr
			else:
				_,f,err = os.popen3(command,'r')
			f.close()
			

if __name__ == '__main__':
	e = ExportLayers()
	e.affect(output=False)
