import tkinter as TK
import tkinter.ttk as TTK
import configparser
import os
import subprocess

import ol_data
import ol_work

class OLgui(TK.Tk):
    """
    gui for ol classes
    """
    
    def __init__(self, parent):
        TK.Tk.__init__(self, parent)
        self.parent = parent
        self.initialize()


    def initialize(self):
        self.cfg = configparser.ConfigParser(allow_no_value=True)
        self.cfg.read('config.ini')        

        self.title(self.cfg['GUI']['title'])
        self.minsize(width=self.cfg['GUI']['width'], height=self.cfg['GUI']['height'])
        self.overwrite_flag = TK.IntVar(value=self.cfg['OPTIONS']['overwrite_output'])
        self.make_pdf_flag = TK.IntVar(value=self.cfg['OPTIONS']['make_pdf'])
        self.print_pdf_flag = TK.IntVar(value=False)
        self.output_key = TK.StringVar()
        self.output_path = TK.StringVar(value=self.cfg['PATH']['output_path'])
        self.pdf_cmd = self.cfg['PATH']['pdf_cmd']
        self.svg_edit = self.cfg['PATH']['svg_edit']
        self.pdf_print = []
        for para in self.cfg['PDF_PRINT']:
            self.pdf_print.append(self.cfg['PDF_PRINT'][para])
        self.prt = TK.StringVar(value=self.cfg['PRINTER']['default'])

        self.grid()
        self.columnconfigure(0, weight=4)
        self.columnconfigure(1, weight=4)
        self.columnconfigure(2, weight=2)
        self.rowconfigure(2, weight=4)

        # listbox for choosing template
        TK.Label(text='Templates').grid(column=0, row=0, sticky='W')
        self.templates_lb = TK.Listbox()
        self.templates_lb.config(exportselection=0)
        self.templates_lb.grid(column=0, row=2, sticky='WENS')
        self.templates_lb.curpath = os.path.abspath(self.cfg['PATH']['templates'])
        self.templates_lb.curfile = None
        self.templates_lb.extfilter = ['.svg']
        self.templates_lb.status = TK.StringVar()
        TK.Label(textvariable=self.templates_lb.status).grid(column=0, row=1, sticky='W')

        # listbox for choosing data
        TK.Label(text='Data').grid(column=1, row=0, sticky='W')
        self.data_lb = TK.Listbox()
        self.data_lb.config(exportselection=0)
        self.data_lb.grid(column=1, row=2, sticky='WENS')
        self.data_lb.curpath = os.path.abspath(self.cfg['PATH']['templates_data'])
        self.data_lb.curfile = None
        self.data_lb.extfilter = ['.csv']
        self.data_lb.status = TK.StringVar()
        TK.Label(textvariable=self.data_lb.status).grid(column=1, row=1, sticky='W')

        # framed buttons and options
        self.buttons = TK.Frame()
        self.buttons.config(padx=10, pady=10)
        self.buttons.grid(column=2, row=2, sticky='WENS')
        
        # Overwrite existing
        self.overwrite_cb = TK.Checkbutton(master=self.buttons,
                                           text='Overwrite existing',
                                           variable=self.overwrite_flag)
        self.overwrite_cb.pack(anchor='w')
        
        # Make PDF´s
        self.make_pdf_cb = TK.Checkbutton(master=self.buttons,
                                           text='Make PDF´s',
                                           variable=self.make_pdf_flag)
        self.make_pdf_cb.pack(anchor='w')

        # Select Naming for output files
        TK.Label(master=self.buttons, text='Name output with:').pack(anchor='w')
        self.output_om = TK.OptionMenu(self.buttons, self.output_key, None)
        self.output_om.pack(fill='x')

        # output path / path selector
        TK.Label(master=self.buttons, text='Output path:').pack(anchor='w')
        self.output_en = TK.Entry(master=self.buttons, textvariable=self.output_path)
        self.output_en.pack(fill='x')

        TTK.Separator(master=self.buttons, orient='horizontal').pack(fill='x', pady=10)

        # Print PDF´s
        self.print_pdf_cb = TK.Checkbutton(master=self.buttons,
                                           text='Print PDF´s',
                                           variable=self.print_pdf_flag)
        self.print_pdf_cb.pack(anchor='w')
        TK.Label(master=self.buttons, text='Printer:').pack(anchor='w')
        self.print_pdf_en = TK.Entry(master=self.buttons, textvariable=self.prt)
        self.print_pdf_en.pack(fill='x')        

        TTK.Separator(master=self.buttons, orient='horizontal').pack(fill='x', pady=10)

        # Generate 
        self.generate_bt = TK.Button(master=self.buttons, text='Generate')
        self.generate_bt.pack(expand=True, fill='both')

        TTK.Separator(master=self.buttons, orient='horizontal').pack(fill='x', pady=10)

        # open config
        self.open_config_bt = TK.Button(master=self.buttons, text='Config')
        self.open_config_bt.pack(expand=False, fill='x')

        # bind widgets to functions     
        self.templates_lb.bind("<<ListboxSelect>>", self.fill_listbox)
        self.templates_lb.bind("<Double-Button-1>", self.open_template)
        self.data_lb.bind("<<ListboxSelect>>", self.fill_listbox)
        self.output_en.bind("<Double-Button-1>", self.output_path_select)
        self.generate_bt.bind("<Button-1>", self.generate)
        self.open_config_bt.bind("<Button-1>", self.open_config)

        # init widgets
        self.fill_listbox(self.templates_lb)
        self.fill_listbox(self.data_lb)


    def open_config(self, ptr=None):
        os.system('config.ini')


    def output_path_select(self, ptr):
        options = {}
        options['initialdir'] = self.output_path.get()
        self.output_path.set(self.path_select(ptr, options))


    def path_select(self, ptr=None, options=None):
        widget = ptr.widget
        if options == None:
            options={}
        return(TK.filedialog.askdirectory(**options))
        

    def open_template(self, ptr):
        widget = ptr.widget
        path = {'svgfile': os.path.abspath(
                os.path.join(widget.curpath, widget.get(widget.curselection())))}
        cmd = self.svg_edit.format(**path)
        print(cmd)
        subprocess.Popen(cmd)


    def fill_listbox(self, ptr=None):
        if type(ptr) == TK.Listbox:
            widget = ptr
        else:
            widget = ptr.widget
        
        selected = widget.curselection()
        if selected:
            path = os.path.abspath(
                os.path.join(widget.curpath, widget.get(selected)))
        else:
            path = os.path.abspath(widget.curpath)
                        
        if os.path.isdir(path):
            widget.curpath = path
            widget.status.set(path)
            widget.delete(0, 'end')
            for e in os.listdir(widget.curpath):
                if os.path.isdir(os.path.join(widget.curpath, e)):
                    widget.insert('end', e)
                    widget.itemconfig('end', background='orange')
            for e in os.listdir(widget.curpath):
                if os.path.splitext(e)[1] in widget.extfilter:
                    widget.insert('end', e)                    
            widget.insert(0, '..')
            widget.itemconfig(0, background='darkorange')
            widget.curfile = None
        else:
            widget.curfile = path

        if widget == self.data_lb:
            menu = self.output_om.children['menu']
            menu.delete(0, 'end')
            self.output_key.set(None)
            if widget.curfile != None:
                labeldata = ol_data.OLData(path)
                for field in labeldata.fieldnames():
                    menu.add_command(label=field, command=TK._setit(self.output_key, value=field))


    def generate(self, ptr=None):
        labeldata = ol_data.OLData(self.data_lb.curfile)
        xml = ol_work.OLgenerate(self.templates_lb.curfile, labeldata)
        xml.output_path = self.output_path.get()
        xml.naming = self.output_key.get()
        xml.overwrite = self.overwrite_flag.get()
        xml.make_pdf_flag = self.make_pdf_flag.get()
        xml.print_pdf_flag = self.print_pdf_flag.get()
        xml.pdf_cmd = self.pdf_cmd
        xml.pdf_print = self.pdf_print
        xml.prt = self.prt.get()
        xml.work()        


if __name__ == '__main__':
    gui = OLgui(None)
    gui.mainloop()
    
