import xml.etree.ElementTree as ET


class OLsvg():

    def __init__(self):        
        self.barcode = ET.Element("root") # group the barcode parts
        

    def generateCode(self, ean="400262903401"):
        bc = EanBarCode()
        b, h = bc.create(ean)
        
        xpos = 20
        plist = []
        for e, c in b:
            if e == "2":
                plist.append(xpos)
                mh = 5
            if e != "0":
                r = self.svg_rect(x=xpos, width=c, height=(20 + mh))
            xpos += abs(c)
            mh = 0
        self.svg_text(plist[0] - 5, 29, h[0], "end")
        self.svg_text(plist[2] - 1, 29, h[1:7], "end")
        self.svg_text(plist[3] + 2, 29, h[7:13], "start")
        return self.barcode


    def svg_rect(self, x=0, y=0, width=1, height=20, style="fill:rgb(0,0,0);stroke:none"):
        e = ET.SubElement(self.barcode, "svg:rect")
        e.set("x", str(x))
        e.set("y", str(y))
        e.set("width", str(width))
        e.set("height", str(height))
        e.set("style", style)


    def svg_text (self, tPosX=100, tPosY=100, tString='<empty>', align='start'):
        new = ET.SubElement(self.barcode,'svg:text')
        #s = {'font-size': '12', 'fill-opacity': '1.0', 'stroke': 'none',
        #'font-weight': 'normal','font-family':'Arial', 'font-style': 'normal', 'fill': '#000000'}
        f = "font-size:10;text-anchor:{}".format(align)
        new.set('style', f)
        new.set('x', str(tPosX))
        new.set('y', str(tPosY))
        new.text = tString



class EanBarCode:

    def __init__(self):
        self.t = [["0001101","0100111","1110010"],["0011001","0110011","1100110"],
                  ["0010011","0011011","1101100"],["0111101","0100001","1000010"],
                  ["0100011","0011101","1011100"],["0110001","0111001","1001110"],
                  ["0101111","0000101","1010000"],["0111011","0010001","1000100"],
                  ["0110111","0001001","1001000"],["0001011","0010111","1110100"]]
        self.f = ["000000","001011","001101","001110","010011","011001","011100","010101","010110","011010"]
        self.border = "202"
        self.middle = "02020"


    def create(self, cb):
        cbInt=[]
        for digit in cb:
            cbInt.append(int(digit))        
        txtBarre = str(cb)
        cbInt.append(self.checksum(cbInt))
        txtBarre += str(cbInt[-1])
        
        bcle1=6
        bcle2=13
        if len(cbInt)==8:
            cbInt.insert(0,0)
            bcle1=4
            bcle2=9

        cbBin = self.border
        for i in range(0,bcle1):
            cbBin += self.t[cbInt[i+1]][int(self.f[cbInt[0]][i])]
        cbBin += self.middle
        for i in range (bcle1+1,bcle2):
            cbBin += self.t[cbInt[i]][2]
        cbBin += '202'

        line = cbBin + ' ' 
        c = 1
        mlist = []
        for i in range(0, len(line) - 1):
            if line[i] == line[i+1]:
                c += 1
            else:
                mlist.append((line[i], c))
                c = 1
        return mlist, txtBarre


    def checksum(self, cb):
        coef = [3,1]
        total = 0
        for i in range(len(cb)-1,-1,-1):
            total += coef[(len(cb)-i-1)%2]*(cb[i])
        return ((10-(total%10) )%10)


def main():
    bc = OLsvg()
    bc.generateCode()
    ET.dump(bc.barcode)


    
if __name__ == '__main__':
    main()
