#!/usr/bin/env python
import sys
import inkex
import simplestyle

SEP_CHAR =  u' '

class CParse( inkex.Effect ):
    def __init__(self):
        inkex.Effect.__init__(self)

    def effect(self):
        svg = self.document.getroot()
        options = {}
        fic = open("data.txt", "r") #.readlines()

        # Parse the data file
        for line in fic:
            name, color = line.split(SEP_CHAR, 1)
            name = name.strip()
            color = color.strip()
            options[name] = color # Dict
            # inkex.debug(name+ " | "+color) # uncomment to show the results
        fic.close()

        # Parse the options dictionnary
        for ids in options:
            try:
                node = self.getElementById(ids)
                # inkex.debug(node)
                style = { 'stroke':str('#'+options[ids]), 'fill':str('#'+options[ids]) }
                node.set('style', simplestyle.formatStyle(style) )
            except:
                pass

Parse = CParse()
Parse.affect()
