import sys
import inkex
import simplestyle
import csv 
# import os 

            
class changecolor(inkex.Effect):

    def __init__(self):
        inkex.Effect.__init__(self)
        
        self.OptionParser.add_option("-d","--datafile",
            action="store", type="string",
            dest="datafile", default="D:\Downloads\TEMMP\Example\Example.txt",
            help="The Id and color file")
            
        self.OptionParser.add_option( "--fill",
            action="store", type="string",
            dest="fill", default="000000ff",
            help="Fill Color" )

    def effect(self):
        #Get access to main SVG document element and get its data.
        svg = self.document.getroot()
        parent = self.current_layer
        
        csvfile = self.options.datafile
        #replace delimiters in data file with space 
        data = []
        with open(csvfile, "rb") as csvfile:
            # Get delimiter from file
            dialect = csv.Sniffer().sniff(csvfile.read(256))
            # Set filepointer back to start of file
            csvfile.seek(0)
            # Read file to memory
            reader = csv.reader(csvfile, dialect)
            # Make a list of the id and color data
            for line in reader:
                data = data + line

        # Go through all selected items and check for id in data
        # if found replace fill with filldata from data list
        # for node in self.selected.iteritems():
        # Todo - preserve stroke ?
        
        for id, node in self.selected.iteritems():
            styles = simplestyle.parseStyle(node.get('style')) 
            # inkex.debug(styles)
            nodeID = node.get('id')
            # inkex.debug(nodeID)
            if nodeID in data:
                pos = data.index(nodeID)
                newcolor = '#' + data[pos + 1]
                # inkex.debug(newcolor)
                style = {'fill':str(newcolor)}
                # inkex.debug(style)
                node.set('style', simplestyle.formatStyle(style) )
                
effect = changecolor()
effect.affect()