#! python
# -*- coding: utf-8 -*-

import math
import colorsys

##
#
# Less sucking default palette for inkscape!
# linear colors are converted to sRgb color space,
# to get better results. (... let`s hope that some sunny day
# gamma mixup will be solved!)
#
##

gamma_palette = '''GIMP Palette
Name: Inkscape Gamma
Columns: 3
'''

def rgb_to_hex(rgb):
    return '#{0[0]:02X}{0[1]:02X}{0[2]:02X}'.format(rgb)

def add_hls_to_palette(h, l, s, comment = ''):
    global gamma_palette
    rgb = sRgb(*colorsys.hls_to_rgb(h, l, s))
    rgb = [int(math.floor(255.0 * v)) for v in rgb]
    comment = rgb_to_hex(rgb) +' '+ comment.replace('\n', ' - ')
    gamma_palette += '{:3} {:3} {:3}  {comment}\n'.format(*rgb, comment = comment)

def sRgb(*rgb):
    return [v * 12.92 if v <= 0.0031308 else 1.055 * v ** (1.0 / 2.4) - 0.055 for v in rgb]

def hsl_2_rgb(h, l, s):
    h = h * 360.0
    c = (1.0 - abs(2.0 * l - 1.0)) * s
    #x = c * (1.0 - abs((h / 60.0) mod 2 - 1.0))
    m = l - c / 2.0
    if     0 <= c <  60:
        return c + m, x + m, m
    elif  60 <= c < 120:
        return x + m, c + m, m
    elif 120 <= c < 180:
        return m, c + m, x + m
    elif 180 <= c < 240:
        return m, x + m, c + m
    elif 240 <= c < 300:
        return x + m, m, c + m
    elif 300 <= c <= 360:
        return c + m, m, x + m

# black to white gradient
h = 0.0
s = 0.0
for ll in range(14):
    l = ll / 13.0
    last = ll == 13
    add_hls_to_palette(h, l, s, comment = '<br>'*last)

# saturated gradients of all hues
# pure black & white excluded
l_offset = (0.5 / 12.0)
s = 1.0
for hh in range(13):
    h = hh / 13.0
    for ll in range(14):
        l = l_offset + (ll / 14.0)
        last = ll == 13
        add_hls_to_palette(h, l, s, comment = '<br>'*last)

# padding
add_hls_to_palette(0.0, 0.0, 0.0, comment = 'padding<br>')

# dark & light basic colors 
s = 1.0
for hh in range(7):
    h = hh / 8.0
    for l in (0.25, 0.5):
        last = (l == 0.5) and (hh == 6)
        add_hls_to_palette(h, l, s, comment = '<br>'*last)

# DE-saturated gradients of all hues
# pure black & white excluded
l_offset = (0.5 / 12.0)
s = 0.5
for hh in range(13):
    h = hh / 13.0
    for ll in range(14):
        l = l_offset + (ll / 14.0)
        last = ll == 13
        add_hls_to_palette(h, l, s, comment = '<br>'*last)

# copy resulting gamma_palette.gpl to <programs>/inkscape/share/palettes
with open('gamma_palette.gpl', 'w') as f:
    f.write(gamma_palette)

