#!/usr/bin/env python

# These two lines are only needed if you don't put the script directly into
# the installation directory
import sys
sys.path.append('/usr/share/inkscape/extensions')

# We will use the inkex module with the predefined Effect base class.
import inkex
# The simplestyle module provides functions for style parsing.
from simplestyle import *
import simpletransform
import numpy as np

import skimage
from skimage import feature
from skimage import data

#from ink2canvas.canvas import Canvas
#import ink2canvas.svg as svg
	

CX = '{http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd}cx'
CY = '{http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd}cy'
HREF = '{http://www.w3.org/1999/xlink}href'

def	draw_SVG_square((w,h), (x,y),color,parent):
    style = {   'stroke'        : 'none',
				      'stroke-width'  : '1',
				      'fill'          : color
				  }				            
    attribs = {
			'style'     : formatStyle(style),
			'height'    : str(h),
			'width'     : str(w),
			'x'         : str(x),
			'y'         : str(y)
				  }
    inkex.etree.SubElement(parent, inkex.addNS('rect','svg'), attribs )

class PVEffect(inkex.Effect):

    def __init__(self):
        inkex.Effect.__init__(self)

    def effect(self):
 				
        svg = self.document.getroot()
        width  = inkex.unittouu(svg.get('width'))
        height = inkex.unittouu(svg.attrib['height'])
        
        layer = inkex.etree.SubElement(svg, 'g')
        layer.set(inkex.addNS('label', 'inkscape'), 'Peaks * Valleys' )
        layer.set(inkex.addNS('groupmode', 'inkscape'), 'layer')
        

        for node in self.selected.itervalues():
         
          f = node.attrib.get(HREF,'').strip()

          img = skimage.data.imread(f)
          gri = skimage.color.rgb2gray(img)

          maxs = skimage.feature.peak_local_max(gri,indices=True)
          mins = skimage.feature.peak_local_max(1-gri,indices=True)
					
          colors = [img[x,y,] for [x,y] in maxs]
          colors = [(r,g,b) for [r , g , b] in colors]
          colors = map(lambda x: '#%02x%02x%02x' % x,colors )
          for (x,c) in zip(maxs,colors):
            draw_SVG_square((5,5), (x[1],x[0]),c,layer)
          colors = [img[x,y,] for [x,y] in mins]
          colors = [(r,g,b) for [r , g , b] in colors]
          colors = map(lambda x: '#%02x%02x%02x' % x,colors )            
          for (x,c) in zip(mins,colors):
            draw_SVG_square((5,5), (x[1],x[0]),c,layer)
          

# Create effect instance and apply it.
effect = PVEffect()
effect.affect()
