#! /usr/bin/env python
# Extension by Ragnar Stiansen - Dec 2014

'''
Set stroke color same as fill color on objects.

Made in Dec  2014 by Ragnar Stiansen
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import sys
import inkex
import simplestyle
import copy


class Setstroke(inkex.Effect):
    """ Set stroke color on selected objects to be same as the fill color """
    __version__ = "0.01"

    def __init__(self):
        inkex.Effect.__init__(self)

        self.OptionParser.add_option("--D_debug",
            action="store", type="inkbool",
            dest="D_debug", default=False,
            help="Verbose output if true")

    def effect(self):
        """ Main """

        # Function to determine if file exists
        def file_exists(filename):
            """ Checks for file existence. """
            try:
                with open(filename) as dummyfile:
                    return True
            except IOError:
                return False
        # End def

        debug = False
        #Check if debug message option is "on" in dialog.
        if self.options.D_debug:
            debug = True
            message = ("Debug on\nExtension version: " +
                        self.__version__ +
                       "\nExpand this window to see debug messages.")
            inkex.debug(message)

        # Just for 'fun' - report Python version
        if debug:
            cur_version = sys.version_info
            message = "Python version: " + str(cur_version) + "\n"
            inkex.debug(message)

        # Get access to main SVG document element and get its data.
        # svg = self.document.getroot()
        # parent = self.current_layer
        # Go through all selected items in svg file and set stroke color same as fill color.
        # for node in self.selected.iteritems():
        if debug:
            def pretty_message(dict_inn):
                """ Formats output of hex data """
                # Needs more 'polishing' d.t. the proportional
                # font used in debug window.
                temp = 0
                temp_string = ""
                for values in dict_inn:
                    temp += 1
                    if temp % 5 == 0:
                        temp_string += "\n"
                    temp_string += ("\t\t" + (str(temp).rjust(4) +
                                    "\t: " + values.rjust(10)))
                return(temp_string)
				
				
        # Iterate over all selected items
        items = 0
        colors_found = False
        items_found = False
        allowed_to_change = ('fill')
			
        # for myid, item in self.selected.iteritems():
        for myid, myitem in self.selected.iteritems():
            node = self.getElementById(myid)
            styles = simplestyle.parseStyle(myitem.get("style"))
            items_found = True
            items += 1
            # Create copy of styles - change values in this to
            # avoid "double change"
            # Use deepcopy to get a new copy and not only a reference
            # to original styles
            new_styles = copy.deepcopy(styles)

            for key, value in styles.iteritems():
                # allow changes for stroke and fill only
				# find style of fill
				
                if key in allowed_to_change:
					stroke_value = value
					new_styles[key] = new_styles[key] + ';stroke:' + value
					colors_found = "True"

					if debug:
						message = (' Stroke set to:' +  value)
						inkex.debug(message)
            node.set("style", simplestyle.formatStyle(new_styles))

        if items_found is False:
            message = ("No items were selected.\n - " +
                       " Select items to be changed before" +
                       " running extension.")
            inkex.debug(message)

        elif debug:
            message = ("A total of: " + str(items) +
                       " stroke color")
            if items > 1:
                message += "s"
            message += " ( were set."
            inkex.debug(message)
		
e = Setstroke()
e.affect()
