#! /usr/bin/python
# Copyright (C) 2015 Mark Crutch
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Add or remove names from the class attribute of the selected objects
"""

import inkex

class ModifyClassList(inkex.Effect):
  def __init__(self):
      inkex.Effect.__init__(self)
      self.OptionParser.add_option("--classList")
      self.OptionParser.add_option("--addOrRemove")
      self.OptionParser.add_option("--removeIfEmpty")

  def effect(self):
      #inkex.debug("Running Code");
      classList = self.options.classList.split()
      addOrRemove = self.options.addOrRemove
      removeIfEmpty = self.options.removeIfEmpty
      elements = self.selected.values()

      for id, node in self.selected.iteritems():
        oldClass = node.get("class")
        if oldClass is not None:
          oldList = oldClass.split()
        else:
          oldList = []

        for item in classList:
          if addOrRemove == "addClass":
            if item not in oldList:
              oldList.append(item)
          else:
            if item in oldList:
              oldList.remove(item)

        newList = " ".join(oldList)

        if addOrRemove == "removeAttribute" or (len(newList) == 0 and removeIfEmpty == 'true'):
          del node.attrib["class"]
        else:
          node.set("class", newList)


if __name__ == '__main__':
  effect = ModifyClassList()
  effect.affect()

